<?php

namespace App\Models\CaseFileItem;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CaseFileItem extends Eloquent {

	protected $table = 'case_files_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('file', 'case_id', 'Judgment');

	public function case()
	{
		return $this->hasMany('Xcase');
	}

	public function judgment()
	{
		return $this->hasMany('Judgment');
	}

}