<?php

namespace CourtItem;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class CourtItem extends Eloquent {

	protected $table = 'courts_items';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('court_type_id', 'court_name_id', 'case_id');

	public function courtType()
	{
		return $this->hasMany('CourtType', 'court_type_id');
	}

	public function courtName()
	{
		return $this->hasMany('CourtName');
	}

}