<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AdditionalFile extends Model 
{

    protected $table = 'candidate_cv_additional_files';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cv_id', 'name', 'path', 'file_type_id');

    public function cv()
    {
        return $this->belongsTo('App\CandidateCV', 'cv_id');
    }

    public function fileType()
    {
        return $this->belongsTo('App\Lookup', 'file_type_id');
    }

}