<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Certificate extends Model 
{

    protected $table = 'candidate_cv_certificates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('cv_id', 'title', 'issuer', 'issue_date', 'location_id');

    public function cv()
    {
        return $this->belongsTo('App\CandidateCV', 'cv_id');
    }

    public function location()
    {
        return $this->belongsTo('App\Location');
    }

}