<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Location extends Model 
{

    protected $table = 'locations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('parent_id', 'type', 'title', 'title_farsi', 'country_code', 'sequence');

    public function candidatesByLocation()
    {
        return $this->hasMany('App\Candidate', 'location_id');
    }

    public function candidatesByNationality1()
    {
        return $this->hasMany('App\Candidate', 'nationality_1');
    }

    public function candidatesByNationality2()
    {
        return $this->hasMany('App\Candidate', 'nationality_2');
    }

    public function cvProfessionalExperiencesByLocation()
    {
        return $this->hasMany('App\ProfessionalExperience');
    }

    public function cvCertificatesByLocation()
    {
        return $this->hasMany('App\Certificate');
    }

    public function candidateTargetJobByLocation()
    {
        return $this->belongsToMany('App\TargetJob', 'candidate_target_job_job_location', 'location_id', 'target_job_id');
    }

    public function phoneNumbersByCountryCode()
    {
        return $this->hasMany('App\CandidatePhoneNumber', 'country_code_id');
    }

}