<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReservationPackagesTable extends Migration {

	public function up()
	{
		Schema::create('reservation_packages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('inherit_id')->unsigned()->nullable();
			$table->integer('reservation_id')->unsigned();
			$table->bigInteger('reseptionist_id')->unsigned()->nullable();
			$table->string('name', 100);
			$table->integer('drinks');
			$table->decimal('price', 10,4);
			$table->integer('pax');
			$table->decimal('total', 10,4);
			$table->string('pax_name', 100);
			$table->string('room', 100)->nullable();
			$table->integer('country_id')->unsigned();
			$table->boolean('was_upgrated')->nullable()->default(false);
			$table->integer('upgrade_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('reservation_packages');
	}
}