<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellsTable extends Migration {

	public function up()
	{
		Schema::create('sells', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('seller_id')->unsigned();
			$table->string('sellable_type', 50);
			$table->integer('sellable_id');
			$table->decimal('grand_total', 10,4);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sells');
	}
}