<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('module_id')->references('id')->on('modules')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('permission_user', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('permission_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hotel_location', function(Blueprint $table) {
			$table->foreign('hotel_id')->references('id')->on('hotels')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->foreign('upgrade_from')->references('id')->on('packages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('hotel_id')->references('id')->on('hotels')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('agency_id')->references('id')->on('agencies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('hotel_location')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->foreign('inherit_id')->references('id')->on('packages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->foreign('reseptionist_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->foreign('upgrade_id')->references('id')->on('reservation_packages')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('package_actions', function(Blueprint $table) {
			$table->foreign('reseptionist_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('package_actions', function(Blueprint $table) {
			$table->foreign('reservation_package_id')->references('id')->on('reservation_packages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('package_actions', function(Blueprint $table) {
			$table->foreign('action_id')->references('id')->on('actions')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sold_packages', function(Blueprint $table) {
			$table->foreign('inherit_id')->references('id')->on('packages')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('sold_packages', function(Blueprint $table) {
			$table->foreign('direct_sells_id')->references('id')->on('direct_sells')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('direct_sells', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('sells', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('vip_sells', function(Blueprint $table) {
			$table->foreign('seller_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('vip_sells', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('currency_configs', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cash_count', function(Blueprint $table) {
			$table->foreign('supevisor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cash_count', function(Blueprint $table) {
			$table->foreign('cashier_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cash_count_money', function(Blueprint $table) {
			$table->foreign('cash_count_id')->references('id')->on('cash_count')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cash_count_money', function(Blueprint $table) {
			$table->foreign('currency_config_id')->references('id')->on('currency_configs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cash_count_money', function(Blueprint $table) {
			$table->foreign('cash_count_total_id')->references('id')->on('cash_count_totals')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cash_count_totals', function(Blueprint $table) {
			$table->foreign('cash_count_id')->references('id')->on('cash_count')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('cash_count_totals', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hotel_route', function(Blueprint $table) {
			$table->foreign('hotel_id')->references('id')->on('hotels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('hotel_route', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('route')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('route_details', function(Blueprint $table) {
			$table->foreign('reservation_id')->references('id')->on('reservations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dayprice', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('packages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->foreign('hotel_id')->references('id')->on('hotels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('print_log', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_module_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_role_id_foreign');
		});
		Schema::table('role_user', function(Blueprint $table) {
			$table->dropForeign('role_user_user_id_foreign');
		});
		Schema::table('login_attempts', function(Blueprint $table) {
			$table->dropForeign('login_attempts_user_id_foreign');
		});
		Schema::table('permission_user', function(Blueprint $table) {
			$table->dropForeign('permission_user_permission_id_foreign');
		});
		Schema::table('permission_user', function(Blueprint $table) {
			$table->dropForeign('permission_user_user_id_foreign');
		});
		Schema::table('agents', function(Blueprint $table) {
			$table->dropForeign('agents_agency_id_foreign');
		});
		Schema::table('hotel_location', function(Blueprint $table) {
			$table->dropForeign('hotel_location_hotel_id_foreign');
		});
		Schema::table('packages', function(Blueprint $table) {
			$table->dropForeign('packages_upgrade_from_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_hotel_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_agency_id_foreign');
		});
		Schema::table('reservations', function(Blueprint $table) {
			$table->dropForeign('reservations_route_id_foreign');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->dropForeign('reservation_packages_inherit_id_foreign');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->dropForeign('reservation_packages_reseptionist_id_foreign');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->dropForeign('reservation_packages_country_id_foreign');
		});
		Schema::table('reservation_packages', function(Blueprint $table) {
			$table->dropForeign('reservation_packages_upgrade_id_foreign');
		});
		Schema::table('vouchers', function(Blueprint $table) {
			$table->dropForeign('vouchers_reservation_id_foreign');
		});
		Schema::table('package_actions', function(Blueprint $table) {
			$table->dropForeign('package_actions_reseptionist_id_foreign');
		});
		Schema::table('package_actions', function(Blueprint $table) {
			$table->dropForeign('package_actions_reservation_package_id_foreign');
		});
		Schema::table('package_actions', function(Blueprint $table) {
			$table->dropForeign('package_actions_action_id_foreign');
		});
		Schema::table('sold_packages', function(Blueprint $table) {
			$table->dropForeign('sold_packages_inherit_id_foreign');
		});
		Schema::table('sold_packages', function(Blueprint $table) {
			$table->dropForeign('sold_packages_direct_sells_id_foreign');
		});
		Schema::table('direct_sells', function(Blueprint $table) {
			$table->dropForeign('direct_sells_seller_id_foreign');
		});
		Schema::table('sells', function(Blueprint $table) {
			$table->dropForeign('sells_seller_id_foreign');
		});
		Schema::table('vip_sells', function(Blueprint $table) {
			$table->dropForeign('vip_sells_seller_id_foreign');
		});
		Schema::table('vip_sells', function(Blueprint $table) {
			$table->dropForeign('vip_sells_reservation_id_foreign');
		});
		Schema::table('currency_configs', function(Blueprint $table) {
			$table->dropForeign('currency_configs_currency_id_foreign');
		});
		Schema::table('cash_count', function(Blueprint $table) {
			$table->dropForeign('cash_count_supevisor_id_foreign');
		});
		Schema::table('cash_count', function(Blueprint $table) {
			$table->dropForeign('cash_count_cashier_id_foreign');
		});
		Schema::table('cash_count_money', function(Blueprint $table) {
			$table->dropForeign('cash_count_money_cash_count_id_foreign');
		});
		Schema::table('cash_count_money', function(Blueprint $table) {
			$table->dropForeign('cash_count_money_currency_config_id_foreign');
		});
		Schema::table('cash_count_money', function(Blueprint $table) {
			$table->dropForeign('cash_count_money_cash_count_total_id_foreign');
		});
		Schema::table('cash_count_totals', function(Blueprint $table) {
			$table->dropForeign('cash_count_totals_cash_count_id_foreign');
		});
		Schema::table('cash_count_totals', function(Blueprint $table) {
			$table->dropForeign('cash_count_totals_currency_id_foreign');
		});
		Schema::table('notes', function(Blueprint $table) {
			$table->dropForeign('notes_user_id_foreign');
		});
		Schema::table('hotel_route', function(Blueprint $table) {
			$table->dropForeign('hotel_route_hotel_id_foreign');
		});
		Schema::table('hotel_route', function(Blueprint $table) {
			$table->dropForeign('hotel_route_route_id_foreign');
		});
		Schema::table('route_details', function(Blueprint $table) {
			$table->dropForeign('route_details_reservation_id_foreign');
		});
		Schema::table('dayprice', function(Blueprint $table) {
			$table->dropForeign('dayprice_package_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_agent_id_foreign');
		});
		Schema::table('employee', function(Blueprint $table) {
			$table->dropForeign('employee_hotel_id_foreign');
		});
		Schema::table('print_log', function(Blueprint $table) {
			$table->dropForeign('print_log_user_id_foreign');
		});
	}
}