<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Agent extends Eloquent {

	protected $table = 'agents';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'phone');

	public function agency()
	{
		return $this->belongsTo('Agency', 'agency_id');
	}

}