<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservation extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('hotel_id', 'agency_id', 'route_id', 'voucher_code', 'agent_name', 'agent_phone', 'date', 'status');
	protected $visible = array('status');

	public function hotel()
	{
		return $this->belongsTo('Hotel');
	}

	public function agency()
	{
		return $this->belongsTo('Agency', 'agency_id');
	}

	public function route()
	{
		return $this->belongsTo('Hotel_location', 'route_id');
	}

	public function packages()
	{
		return $this->hasMany('ReservationPackage', 'reservation_id');
	}

	public function notes()
	{
		return $this->morphMany('Note', 'commentable');
	}

}