<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackagesTable extends Migration {

	public function up()
	{
		Schema::create('packages', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 100);
			$table->integer('drinks');
			$table->decimal('price', 10,4);
			$table->boolean('active')->default(true);
			$table->integer('upgrade_from')->unsigned()->nullable();
			$table->timestamps();
			$table->boolean('reserve_usable')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('packages');
	}
}