<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Listing extends Eloquent {

	protected $table = 'listing';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\User');
	}

	public function reservations()
	{
		return $this->hasMany('App\Reservation');
	}

	public function reviews()
	{
		return $this->hasMany('App\Review');
	}

	public function photos()
	{
		return $this->hasMany('App\Photo');
	}

	public function policy()
	{
		return $this->hasOne('App\Policy');
	}

	public function amenities()
	{
		return $this->hasMany('App\Amenity');
	}

}