<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname');
			$table->string('lastname');
			$table->string('position');
			$table->mediumInteger('uid');
			$table->string('country');
			$table->string('status');
			$table->string('corporation');
			$table->integer('supervisor_id');
			$table->integer('service_id');
			$table->string('mission_state');
			$table->string('phone');
			$table->string('email');
			$table->integer('location_id');
			$table->string('building');
			$table->string('floor');
			$table->string('desk');
			$table->string('cellphone');
			$table->integer('role_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}