<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRatingTable extends Migration {

	public function up()
	{
		Schema::create('rating', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->nullable();
			$table->integer('client_id')->nullable();
			$table->integer('driver_id')->nullable();
			$table->integer('quality')->nullable();
			$table->integer('delivery')->nullable();
			$table->integer('packaging')->nullable();
			$table->text('comment')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('rating');
	}
}