<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingsTable extends Migration {

	public function up()
	{
		Schema::create('Bookings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('customer_name');
			$table->string('email');
			$table->bigInteger('phone');
			$table->bigInteger('whatsapp')->nullable();
			$table->integer('districtid')->unsigned();
			$table->integer('outletid')->unsigned();
			$table->date('delivery_date');
			$table->integer('productid')->unsigned();
			$table->integer('size')->unsigned();
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('Bookings');
	}
}