<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIncomesTable extends Migration {

	public function up()
	{
		Schema::create('incomes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('description');
			$table->integer('value');
			$table->date('date');
			$table->enum('status', array('collected', 'postponed'));
			$table->enum('payment_method', array('cash', 'cheques', 'voucher', 'bank_transfer'));
			$table->integer('bank_id');
			$table->integer('currency_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('incomes');
	}
}