<?php

namespace App\Models\Complexe;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Complexe extends Eloquent {

	protected $table = 'complexes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('App\Models\User\User');
	}

	public function package()
	{
		return $this->belongsTo('App\Models\Package');
	}

}