<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePackageTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('package_translations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name')->nullable();
			$table->text('description')->nullable();
			$table->string('locale')->nullable();
			$table->bigInteger('package_id')->unsigned()->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('package_translations');
	}
}