<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('media_id')->references('id')->on('medias')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('cat_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('lang_id')->references('id')->on('languages')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('country_lang', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('country_lang', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_media_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('medias', function(Blueprint $table) {
			$table->dropForeign('medias_cat_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_cat_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_lang_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('country_lang', function(Blueprint $table) {
			$table->dropForeign('country_lang_country_id_foreign');
		});
		Schema::table('country_lang', function(Blueprint $table) {
			$table->dropForeign('country_lang_language_id_foreign');
		});
	}
}