<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('category_id')->unsigned();
			$table->text('notes')->nullable();
			$table->string('order_num', 191);
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('provider_id')->unsigned()->nullable();
			$table->double('vat_per')->default('0');
			$table->double('vat_amount')->default('0');
			$table->double('final_total')->default('0');
			$table->float('admin_commission_per')->default('0');
			$table->double('admin_commission')->default('0');
			$table->integer('status')->default('0');
			$table->integer('pay_type')->default('0');
			$table->integer('pay_status');
			$table->json('pay_data')->nullable();
			$table->decimal('lat', 10,8)->nullable();
			$table->decimal('lng', 10,8)->nullable();
			$table->string('city', 191)->nullable();
			$table->text('map_desc')->nullable();
			$table->boolean('user_delete')->default(0);
			$table->boolean('provider_delete')->default(0);
			$table->boolean('admin_delete')->default(0);
			$table->date('day')->nullable();
			$table->time('time');
			$table->integer('service_type')->nullable();
			$table->double('maintenance_price')->default('0');
			$table->double('products_price')->nullable()->default('0');
			$table->enum('type', array('maintenance', 'shopping'));
			$table->bigInteger('order_offer_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}