<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOfertaTable extends Migration {

	public function up()
	{
		Schema::create('oferta', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->enum('oferta_status', array('1', '2', '3', '4'));
			$table->float('pret_mwh');
			$table->decimal('consum_estimat', 15);
			$table->timestamp('data_valabilitate_contract');
			$table->timestamp('data_limita_contract');
			$table->string('perioada_contract', 100);
			$table->string('zile_emitere_factura', 100);
			$table->string('termen_plata_factura', 100);
			$table->tinyInteger('energie_reactiva');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('oferta');
	}
}