<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('oferta', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('locatie_consum', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('tichets', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('partener', function(Blueprint $table) {
			$table->foreign('categorie_id')->references('id')->on('categorii_partener')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('partener', function(Blueprint $table) {
			$table->foreign('tip_juridic_id')->references('id')->on('tip_juridic')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('oferta', function(Blueprint $table) {
			$table->dropForeign('oferta_user_id_foreign');
		});
		Schema::table('locatie_consum', function(Blueprint $table) {
			$table->dropForeign('locatie_consum_user_id_foreign');
		});
		Schema::table('tichets', function(Blueprint $table) {
			$table->dropForeign('tichets_user_id_foreign');
		});
		Schema::table('partener', function(Blueprint $table) {
			$table->dropForeign('partener_categorie_id_foreign');
		});
		Schema::table('partener', function(Blueprint $table) {
			$table->dropForeign('partener_tip_juridic_id_foreign');
		});
	}
}