<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBranchesTable extends Migration {

	public function up()
	{
		Schema::create('branches', function(Blueprint $table) {
			$table->increments('id');
			$table->string('lat', 191);
			$table->string('lng', 191);
			$table->string('address', 191);
			$table->integer('city_id')->unsigned()->nullable();
			$table->string('days_off', 191)->default('[]');
			$table->string('time_from', 50);
			$table->string('time_to', 50);
			$table->integer('place_id')->unsigned();
			$table->string('menu', 191)->nullable();
			$table->enum('status', array('0', '1'));
			$table->enum('special_status', array('0', '1'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('branches');
	}
}