<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('Products', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('published')->default('0');
			$table->float('rating_cache', 2,1)->default('3.0');
			$table->integer('rating_count')->default('0');
			$table->string('name', 255);
			$table->float('pricing', 9,2)->default('0.00');
			$table->string('short_description', 255);
			$table->text('long_description');
			$table->string('icon', 255);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Products');
	}
}