<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInqueriesTable extends Migration {

	public function up()
	{
		Schema::create('inqueries', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('url');
			$table->string('ip_address');
			$table->string('name');
			$table->string('email');
			$table->string('phone');
			$table->string('start_date');
			$table->string('end_date');
			$table->string('nationality');
			$table->text('comment');
			$table->integer('tour_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('inqueries');
	}
}