<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Notification extends Eloquent {

	protected $table = 'notifications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function Donation_requests()
	{
		return $this->hasMany('App\Models\DonationRequest', 'donation_request_id');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client', 'client_notification');
	}

}