<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable();
			$table->decimal('sub_total');
			$table->double('discount');
			$table->decimal('shipping');
			$table->double('tax');
			$table->decimal('total');
			$table->string('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}