<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('user_id', 'sub_total', 'discount', 'shipping', 'tax', 'total', 'status');

	public function products()
	{
		return $this->belongsToMany('App\Models\Product');
	}

}