<?php

class Question extends Eloquent {

	protected $table = 'Question';
	public $timestamps = true;
	protected $fillable = array('question', 'description', 'question_type');

	public function possibleAnswers()
	{
		return $this->hasMany('Question_Answers');
	}

	public function questiontype()
	{
		return $this->hasOne('Question_type');
	}

	public function answers()
	{
		return $this->hasMany('Answer');
	}

	public function questionnaire()
	{
		return $this->belongsTo('Questionnaire');
	}

	public function if_question_rule()
	{
		return $this->hasMany('Questionnaire_rule', 'if_question_id');
	}

	public function then_question_rule()
	{
		return $this->hasMany('Questionnaire_rule');
	}

}