<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Entreprise extends Eloquent {

	protected $table = 'entreprise';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function utilisateur()
	{
		return $this->belongsTo(' App\Models\Utilisateur', 'utilisateur_id');
	}

	public function typeentreprise()
	{
		return $this->belongsTo('App\Models\Tpyeentreprise', 'typeentreprise_id');
	}

	public function tpegestion()
	{
		return $this->belongsTo('App\Models\Typegestion', 'typegestion_id');
	}

}