<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->index();
			$table->integer('difficulty_id')->unsigned();
			$table->text('description');
			$table->text('xml_data');
			$table->string('hint_translation');
			$table->integer('min_points')->unsigned();
			$table->integer('max_points')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}