<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTelephonesTable extends Migration {

	public function up()
	{
		Schema::create('telephones', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('client_id')->unsigned();
			$table->timestamps();
			$table->enum('type', array('Domicile', 'Secondaire', 'Travail', 'Autre'));
			$table->integer('telephone');
			$table->enum('favoris', array('0', '1'));
		});
	}

	public function down()
	{
		Schema::drop('telephones');
	}
}