<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateConseillersTable extends Migration {

	public function up()
	{
		Schema::create('conseillers', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('preteur_id')->unsigned();
			$table->timestamps();
			$table->string('prenom', 100);
			$table->string('nom', 100);
			$table->integer('telephone');
			$table->string('email', 100);
			$table->enum('role', array('conseiller', 'chargéprescripteur', 'directeuragence', 'directeurentité'));
		});
	}

	public function down()
	{
		Schema::drop('conseillers');
	}
}