<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('partenaire_id')->unsigned();
			$table->timestamps();
			$table->enum('civilite', array('Monsieur', 'Madame', 'Mademoiselle'));
			$table->string('prenom');
			$table->string('nom');
			$table->string('nomnaissance', 100)->nullable();
			$table->date('naissance');
			$table->string('lieunaissance');
			$table->time('deces');
			$table->enum('situation', array('locataire', 'propriétaire', 'occupantgratuit'));
			$table->string('nationalite', 100);
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}