<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePretsTable extends Migration {

	public function up()
	{
		Schema::create('prets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('bien_id')->unsigned();
			$table->timestamps();
			$table->enum('type', array('amortissable', 'contant', 'infine'));
			$table->integer('duree');
			$table->integer('differe');
			$table->integer('montant');
			$table->string('garantie');
			$table->integer('fraisdossier')->unsigned();
			$table->string('fraiscourtage');
			$table->decimal('tauxpret');
			$table->decimal('tauxassurance');
		});
	}

	public function down()
	{
		Schema::drop('prets');
	}
}