<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('t_question', function(Blueprint $table) {
			$table->foreign('fkSurvey')->references('id')->on('t_survey')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_answer', function(Blueprint $table) {
			$table->foreign('fkQuestion')->references('id')->on('t_question')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_userSurvey', function(Blueprint $table) {
			$table->foreign('fkSurvey')->references('id')->on('t_survey')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_result', function(Blueprint $table) {
			$table->foreign('idfkAnswer')->references('id')->on('t_answer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('t_result', function(Blueprint $table) {
			$table->foreign('idfkUserSurvey')->references('id')->on('t_userSurvey')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('t_question', function(Blueprint $table) {
			$table->dropForeign('t_question_fkSurvey_foreign');
		});
		Schema::table('t_answer', function(Blueprint $table) {
			$table->dropForeign('t_answer_fkQuestion_foreign');
		});
		Schema::table('t_userSurvey', function(Blueprint $table) {
			$table->dropForeign('t_userSurvey_fkSurvey_foreign');
		});
		Schema::table('t_result', function(Blueprint $table) {
			$table->dropForeign('t_result_idfkAnswer_foreign');
		});
		Schema::table('t_result', function(Blueprint $table) {
			$table->dropForeign('t_result_idfkUserSurvey_foreign');
		});
	}
}