<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSpeakersTable extends Migration {

	public function up()
	{
		Schema::create('speakers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 20)->nullable();
			$table->string('email', 30)->nullable();
			$table->string('position', 30)->nullable();
			$table->string('description', 30)->nullable();
			$table->string('image', 50)->nullable();
			$table->string('qualification', 50)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('speakers');
	}
}