<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSociosTable extends Migration {

	public function up()
	{
		Schema::create('socios', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('empresa_id')->unsigned()->nullable();
			$table->string('nome');
			$table->string('cpf', 14)->unique();
			$table->string('nascimento', 10)->nullable();
			$table->string('profissao')->nullable();
			$table->enum('ativo', array('S', 'N'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('socios');
	}
}