<?php

namespace Plenty\Modules\Payment\Model;

class Payment extends Eloquent {

	protected $table = 'plenty_payment';
	public $timestamps = false;

	public function status()
	{
		return $this->hasMany('Plenty\Modules\Payment\Model\PaymentStatus', 'paymentId');
	}

	public function parentId()
	{
		return $this->hasMany('Plenty\Modules\Payment\Model\Payment', 'id');
	}

	public function transactionTypeId()
	{
		return $this->hasMany('Plenty\Modules\Payment\Model\TransactionType', 'id');
	}

	public function paymentMethod()
	{
		return $this->hasOne('Plenty\Modules\Payment\Method\Model\PaymentMethod', 'id');
	}

	public function paymentInformation()
	{
		return $this->hasMany('Plenty\Modules\Payment\Model\PaymentInformation', 'paymentId');
	}

	public function history()
	{
		return $this->hasMany('Plenty\Modules\Payment\History\Model\PaymentHistory', 'paymentId');
	}

	public function transactionInformation()
	{
		return $this->hasMany('Plenty\Modules\Payment\Model\Payment', 'paymentId');
	}

	public function option()
	{
		return $this->hasMany('Plenty\Modules\Payment\Model\Payment', 'paymentId');
	}

}