<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('passenger_id')->unsigned();
			$table->integer('plan_id')->unsigned();
			$table->string('base_price')->nullable();
			$table->string('discount_price')->nullable();
			$table->string('total_price')->nullable();
			$table->tinyInteger('percent_profit')->unsigned()->nullable();
			$table->string('amount_profit')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}