<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePassengersTable extends Migration {

	public function up()
	{
		Schema::create('passengers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name_fa', 60);
			$table->string('last_name_fa', 60);
			$table->string('first_name_en', 60);
			$table->string('last_name_en', 60);
			$table->string('national_code', 12);
			$table->date('birth_date');
			$table->string('email', 100)->nullable();
			$table->string('phone', 12)->nullable();
			$table->enum('gender', array('man', 'woman'));
			$table->string('birth_place', 100)->nullable();
			$table->string('passport_number', 100)->nullable();
			$table->string('post_code', 20)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('passengers');
	}
}