<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('credits', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('operation_records', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('passenger_id')->references('id')->on('passengers')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('user_order_profits', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('linkable_countries', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('insurance_plans', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->foreign('webservice_id')->references('id')->on('webservices')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('covers', function(Blueprint $table) {
			$table->foreign('plan_id')->references('id')->on('plans')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('credits', function(Blueprint $table) {
			$table->dropForeign('credits_user_id_foreign');
		});
		Schema::table('operation_records', function(Blueprint $table) {
			$table->dropForeign('operation_records_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_passenger_id_foreign');
		});
		Schema::table('user_order_profits', function(Blueprint $table) {
			$table->dropForeign('user_order_profits_order_id_foreign');
		});
		Schema::table('linkable_countries', function(Blueprint $table) {
			$table->dropForeign('linkable_countries_country_id_foreign');
		});
		Schema::table('insurance_plans', function(Blueprint $table) {
			$table->dropForeign('insurance_plans_country_id_foreign');
		});
		Schema::table('plans', function(Blueprint $table) {
			$table->dropForeign('plans_webservice_id_foreign');
		});
		Schema::table('covers', function(Blueprint $table) {
			$table->dropForeign('covers_plan_id_foreign');
		});
	}
}