<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('leads', function(Blueprint $table) {
			$table->foreign('tracking_id')->references('id')->on('trackings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('registrations', function(Blueprint $table) {
			$table->foreign('client_id')->references('client_id')->on('leads')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('registrations', function(Blueprint $table) {
			$table->foreign('tracking_id')->references('id')->on('trackings')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('client_id')->references('client_id')->on('registrations')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('leads', function(Blueprint $table) {
			$table->dropForeign('leads_tracking_id_foreign');
		});
		Schema::table('registrations', function(Blueprint $table) {
			$table->dropForeign('registrations_client_id_foreign');
		});
		Schema::table('registrations', function(Blueprint $table) {
			$table->dropForeign('registrations_tracking_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_client_id_foreign');
		});
	}
}