<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function owner()
	{
		return $this->belongsTo('User', 'user_id', 'id');
	}

	public function categories()
	{
		return $this->belongsToMany('Category');
	}

	public function sales()
	{
		return $this->morphMany('Sale', 'saleable')->whereActive(true);
	}

}