<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientTable extends Migration {

	public function up()
	{
		Schema::create('client', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname', 255);
			$table->string('lastname', 255);
			$table->string('address', 255);
			$table->string('address_no', 255);
			$table->string('city', 255);
			$table->string('postcode', 255);
			$table->string('region', 255);
			$table->string('country', 255)->default('Greece');
			$table->string('telephone', 255);
			$table->string('vat', 255)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('client');
	}
}