<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransakcijeTable extends Migration {

	public function up()
	{
		Schema::create('transakcije', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('izvrsena');
			$table->double('iznos')->nullable();
			$table->double('odliv')->nullable();
			$table->double('priliv')->nullable();
			$table->string('vrsta_racuna');
			$table->string('svojstvo_komunikacije');
			$table->string('mb_obveznika');
			$table->string('filijala_obveznika');
			$table->string('mb_vrsi_se');
			$table->string('naviz_vrsi_se');
			$table->string('drzava_vrsi_se');
			$table->string('broj_racuna_vrsi_se');
			$table->string('mb_banke_vrsi_se');
			$table->string('naziv_banke_vrsi_se');
			$table->string('drzava_banke_vrsi_se');
			$table->string('mb_namjenjena');
			$table->string('naziv_namjenjena');
			$table->string('drzava_namjenjena');
			$table->string('broj_racuna_namjenjena');
			$table->string('mb_banke_namjenjena');
			$table->string('naziv_banke_namjenjena');
			$table->string('drzava_banke_namjenjena');
			$table->text('napomena')->nullable();
			$table->integer('id_korisnika')->unsigned();
			$table->integer('id_statusa')->unsigned();
			$table->morphs('physicalable');
			$table->string('legalable');
			$table->morphs('bankable');
			$table->morphs('stockable');
			$table->morphs('insuranceable');
			$table->morphs('otherable');
			$table->boolean('sumnjiva');
			$table->morphs('suspiciousable');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('transakcije');
	}
}