<?php

namespace OtherData;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OtherData extends Model 
{

    protected $table = 'podaci_ostalo';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function subject()
    {
        return $this->belongsTo('TransactionSubject');
    }

    public function transaction()
    {
        return $this->morphMany('Transaction', 'otherable');
    }

}