<?php

namespace Transaction;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Transaction extends Model 
{

    protected $table = 'transakcije';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function status()
    {
        return $this->belongsTo('TransactionStatus');
    }

    public function user()
    {
        return $this->belongsTo('User');
    }

}