<?php

namespace OtherData;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OtherData extends Eloquent {

	protected $table = 'podaci_ostalo';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function subject()
	{
		return $this->belongsTo('TransactionSubject');
	}

	public function transaction()
	{
		return $this->morphMany('Transaction', 'otherable');
	}

}