<?php

namespace Transaction;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Transaction extends Eloquent {

	protected $table = 'transakcije';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function status()
	{
		return $this->belongsTo('TransactionStatus');
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

}